<?php
session_start();
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/helpers.php';

$page_title = 'Login';
$db = db();
// Seed default admin if users table is empty
$cnt = one($db, "SELECT COUNT(*) AS c FROM users")['c'] ?? 0;
if ((int)$cnt === 0) {
  $hash = password_hash('admin123', PASSWORD_DEFAULT);
  $st = $db->prepare("INSERT INTO users(name,email,password_hash,is_active) VALUES('Admin','admin@local',?,1)");
  $st->bind_param("s", $hash);
  $st->execute();
  $st->close();
}

$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $email = trim($_POST['email'] ?? '');
  $pass  = (string)($_POST['password'] ?? '');

  $row = one($db, "SELECT id, name, email, password_hash FROM users WHERE email = ? AND is_active=1 LIMIT 1", "s", [$email]);
  if ($row && password_verify($pass, $row['password_hash'])) {
    $_SESSION['user_id'] = (int)$row['id'];
    $_SESSION['user_name'] = $row['name'];
    $_SESSION['user_email'] = $row['email'];
    flash_set('success', 'Welcome back!');
    header('Location: ' . base_url() . '/public/dashboard.php');
    exit;
  } else {
    $err = 'Invalid email or password.';
  }
}

include __DIR__ . '/../includes/header.php';
?>
<div class="row justify-content-center">
  <div class="col-12 col-sm-10 col-md-6 col-lg-4">
    <div class="card p-4">
      <h4 class="mb-3">Sign in</h4>
      <?php if($err): ?><div class="alert alert-danger"><?= h($err) ?></div><?php endif; ?>
      <form method="post">
        <?= csrf_field() ?>
        <div class="mb-3">
          <label class="form-label">Email</label>
          <input class="form-control" name="email" type="email" required value="<?= h($_POST['email'] ?? 'admin@local') ?>">
        </div>
        <div class="mb-3">
          <label class="form-label">Password</label>
          <input class="form-control" name="password" type="password" required value="">
        </div>
        <button class="btn btn-primary w-100">Login</button>
        <div class="small opacity-75 mt-3">
          Default: <span class="text-info">admin@local</span> / <span class="text-info">admin123</span>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
