<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';

$page_title = 'Items';
$db = db();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $name = trim($_POST['name'] ?? '');
  if ($name !== '') {
    $st = $db->prepare("INSERT INTO items(name) VALUES(?)");
    $st->bind_param("s", $name);
    $st->execute();
    $st->close();
    flash_set('success', 'Item added.');
    header('Location: ' . base_url() . '/public/items.php');
    exit;
  }
}

$items = all($db, "SELECT * FROM items ORDER BY id DESC LIMIT 500");

include __DIR__ . '/../includes/header.php';
?>
<div class="row g-3">
  <div class="col-12 col-lg-4">
    <div class="card p-3">
      <h5>Add item</h5>
      <form method="post" class="mt-2">
        <?= csrf_field() ?>
        <div class="mb-2">
          <label class="form-label">Item name</label>
          <input class="form-control" name="name" required placeholder="e.g. Matches Box">
        </div>
        <button class="btn btn-primary">Save</button>
      </form>
      <div class="small opacity-75 mt-3">After adding an item, click “UOMs & Prices”.</div>
    </div>
  </div>

  <div class="col-12 col-lg-8">
    <div class="card p-3">
      <div class="d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Items</h5>
      </div>
      <div class="table-responsive mt-2">
        <table class="table table-sm align-middle">
          <thead><tr><th>#</th><th>Name</th><th class="text-end">UOMs</th><th></th></tr></thead>
          <tbody>
          <?php foreach($items as $it):
            $cnt = one($db,"SELECT COUNT(*) AS c FROM item_uoms WHERE item_id=?","i",[(int)$it['id']])['c'] ?? 0;
          ?>
            <tr>
              <td><?= (int)$it['id'] ?></td>
              <td><?= h($it['name']) ?></td>
              <td class="text-end"><?= (int)$cnt ?></td>
              <td class="text-end">
                <a class="btn btn-sm btn-outline-info" href="<?= base_url() ?>/public/item_uoms.php?item_id=<?= (int)$it['id'] ?>">UOMs & Prices</a>
              </td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="small opacity-75">Showing up to 500 latest items.</div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
