<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';
$page_title = 'Invoices';
$db = db();

$customer_id = (int)($_GET['customer_id'] ?? 0);
$q = trim($_GET['q'] ?? '');
$where = "1=1";
$params = [];
$types = "";

if ($customer_id > 0) { $where .= " AND i.customer_id=?"; $types.="i"; $params[]=$customer_id; }
if ($q !== '') { $where .= " AND (i.invoice_no LIKE CONCAT('%',?,'%') OR c.name LIKE CONCAT('%',?,'%'))"; $types.="ss"; $params[]=$q; $params[]=$q; }

$rows = all($db, "
  SELECT i.*, c.name AS customer_name
  FROM invoices i
  JOIN customers c ON c.id=i.customer_id
  WHERE $where
  ORDER BY i.id DESC
  LIMIT 500
", $types, $params);

$customers = all($db, "SELECT id,name FROM customers ORDER BY name ASC");

include __DIR__ . '/../includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">Invoices</h4>
  <a class="btn btn-primary" href="<?= base_url() ?>/public/invoice_new.php">+ New invoice</a>
</div>

<div class="card p-3 mb-3">
  <form class="row g-2 align-items-end" method="get">
    <div class="col-12 col-md-4">
      <label class="form-label">Customer</label>
      <select class="form-select" name="customer_id">
        <option value="0">All customers</option>
        <?php foreach($customers as $c): ?>
          <option value="<?= (int)$c['id'] ?>" <?= ($customer_id==(int)$c['id'])?'selected':'' ?>><?= h($c['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-12 col-md-4">
      <label class="form-label">Search</label>
      <input class="form-control" name="q" placeholder="Invoice no or customer" value="<?= h($q) ?>">
    </div>
    <div class="col-12 col-md-4 d-flex gap-2">
      <button class="btn btn-outline-light w-100">Filter</button>
      <a class="btn btn-outline-secondary w-100" href="<?= base_url() ?>/public/invoices.php">Reset</a>
    </div>
  </form>
</div>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead>
        <tr>
          <th>#</th>
          <th>Date</th>
          <th>Invoice</th>
          <th>Customer</th>
          <th class="text-end">Total</th>
          <th class="text-end">Balance</th>
          <th>Status</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
      <?php if(!$rows): ?>
        <tr><td colspan="8" class="opacity-75">No invoices.</td></tr>
      <?php endif; ?>
      <?php foreach($rows as $r):
        $status = $r['status'];
        $bal = (float)$r['balance'];
        $badge = $bal <= 0.0001 ? 'success' : (($bal < (float)$r['total']) ? 'warning' : 'secondary');
      ?>
        <tr>
          <td><?= (int)$r['id'] ?></td>
          <td><?= h($r['invoice_date']) ?></td>
          <td class="fw-semibold"><?= h($r['invoice_no']) ?></td>
          <td><?= h($r['customer_name']) ?></td>
          <td class="text-end">KES <?= money($r['total']) ?></td>
          <td class="text-end <?= ($bal>0.0001)?'text-warning':'' ?>">KES <?= money($r['balance']) ?></td>
          <td><span class="badge text-bg-<?= $badge ?>"><?= h($status) ?></span></td>
          <td class="text-end">
            <a class="btn btn-sm btn-outline-info" href="<?= base_url() ?>/public/invoice_view.php?id=<?= (int)$r['id'] ?>">View</a>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
