<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';
$page_title = 'Stock On-hand';
$db = db();

$q = trim($_GET['q'] ?? '');
$where = "1=1";
$params = [];
$types = "";
if ($q !== '') { $where .= " AND (it.name LIKE CONCAT('%',?,'%') OR it.barcode LIKE CONCAT('%',?,'%'))"; $types="ss"; $params=[$q,$q]; }

$rows = all($db, "
  SELECT it.id, it.name, it.barcode,
         COALESCE(oh.qty_base,0) AS qty_base,
         COALESCE(oh.avg_cost_base,0) AS avg_cost_base
  FROM items it
  LEFT JOIN stock_onhand oh ON oh.item_id=it.id
  WHERE $where
  ORDER BY it.name ASC
  LIMIT 800
", $types, $params);

include __DIR__ . '/../includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">Stock on-hand (base units)</h4>
  <a class="btn btn-primary" href="<?= base_url() ?>/public/grn_receive.php">+ Receive GRN</a>
</div>

<div class="card p-3 mb-3">
  <form class="row g-2">
    <div class="col-12 col-md-6">
      <label class="form-label">Search item / barcode</label>
      <input class="form-control" name="q" value="<?= h($q) ?>" placeholder="e.g. Sugar / 123456...">
    </div>
    <div class="col-12 col-md-6 d-flex gap-2 align-items-end">
      <button class="btn btn-outline-light w-100">Search</button>
      <a class="btn btn-outline-secondary w-100" href="<?= base_url() ?>/public/stock_onhand.php">Reset</a>
    </div>
  </form>
</div>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead><tr><th>Item</th><th>Barcode</th><th class="text-end">Qty (base)</th><th class="text-end">Avg Cost / base</th></tr></thead>
      <tbody>
        <?php if(!$rows): ?><tr><td colspan="4" class="opacity-75">No items.</td></tr><?php endif; ?>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= h($r['name']) ?></td>
            <td><?= h($r['barcode']) ?></td>
            <td class="text-end"><?= h($r['qty_base']) ?></td>
            <td class="text-end">KES <?= number_format((float)$r['avg_cost_base'], 6) ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <div class="small opacity-75">Base units depend on your UOM conversion_qty.</div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
