<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';
$page_title = 'Returns';
$db = db();

$rows = all($db, "
  SELECT r.*, c.name AS customer_name, i.invoice_no
  FROM returns r
  JOIN customers c ON c.id=r.customer_id
  LEFT JOIN invoices i ON i.id=r.invoice_id
  ORDER BY r.id DESC
  LIMIT 300
");

include __DIR__ . '/../includes/header.php';
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h4 class="mb-0">Returns</h4>
  <a class="btn btn-primary" href="<?= base_url() ?>/public/return_new.php">+ New return</a>
</div>

<div class="card p-3">
  <div class="table-responsive">
    <table class="table table-sm align-middle">
      <thead><tr><th>Date</th><th>Return No</th><th>Customer</th><th>Invoice</th><th>Method</th><th class="text-end">Total</th><th></th></tr></thead>
      <tbody>
        <?php if(!$rows): ?><tr><td colspan="7" class="opacity-75">No returns yet.</td></tr><?php endif; ?>
        <?php foreach($rows as $r): ?>
          <tr>
            <td><?= h($r['return_date']) ?></td>
            <td class="fw-semibold"><?= h($r['return_no']) ?></td>
            <td><?= h($r['customer_name']) ?></td>
            <td><?= h($r['invoice_no'] ?? '—') ?></td>
            <td><?= h($r['method']) ?></td>
            <td class="text-end">KES <?= money($r['total']) ?></td>
            <td class="text-end"><a class="btn btn-sm btn-outline-info" href="<?= base_url() ?>/public/return_view.php?id=<?= (int)$r['id'] ?>">View</a></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
