<?php
require_once __DIR__ . '/_pos_boot.php';

$invoice_id = (int)($_GET['invoice_id'] ?? 0);
$inv = $invoice_id ? one($db, "
  SELECT i.*, c.name AS customer_name
  FROM invoices i
  JOIN customers c ON c.id=i.customer_id
  WHERE i.id=?
","i",[$invoice_id]) : null;

if(!$inv){ http_response_code(404); die('Invoice not found'); }

$lines = all($db, "
  SELECT li.*, it.name AS item_name, u.uom_name
  FROM invoice_items li
  JOIN items it ON it.id=li.item_id
  JOIN item_uoms u ON u.id=li.uom_id
  WHERE li.invoice_id=?
  ORDER BY li.id ASC
","i",[$invoice_id]);

$page_title = 'Receipt ' . $inv['invoice_no'];
include __DIR__ . '/../../includes/header.php';
?>

<div class="row justify-content-center">
  <div class="col-12 col-md-7 col-lg-5">
    <div class="card p-3">
      <div class="text-center">
        <div class="fw-bold"><?= h(app_cfg()['app_name']) ?></div>
        <div class="small opacity-75">POS Receipt</div>
      </div>

      <hr class="border-secondary my-3">

      <div class="d-flex justify-content-between"><div class="small opacity-75">Invoice</div><div class="fw-semibold"><?= h($inv['invoice_no']) ?></div></div>
      <div class="d-flex justify-content-between"><div class="small opacity-75">Date</div><div><?= h($inv['invoice_date']) ?></div></div>
      <div class="d-flex justify-content-between"><div class="small opacity-75">Customer</div><div><?= h($inv['customer_name']) ?></div></div>
      <div class="d-flex justify-content-between"><div class="small opacity-75">Status</div><div class="fw-semibold"><?= h($inv['status']) ?></div></div>

      <hr class="border-secondary my-3">

      <table class="table table-sm">
        <thead><tr><th>Item</th><th class="text-end">Qty</th><th class="text-end">Total</th></tr></thead>
        <tbody>
        <?php foreach($lines as $l): ?>
          <tr>
            <td>
              <div class="fw-semibold"><?= h($l['item_name']) ?></div>
              <div class="small opacity-75"><?= h($l['uom_name']) ?> × KES <?= money($l['price']) ?></div>
            </td>
            <td class="text-end"><?= h($l['qty']) ?></td>
            <td class="text-end fw-bold">KES <?= money($l['line_total']) ?></td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>

      <hr class="border-secondary my-3">

      <div class="d-flex justify-content-between align-items-end">
        <div>
          <div class="small opacity-75">BALANCE</div>
          <div class="fw-semibold">KES <?= money($inv['balance']) ?></div>
        </div>
        <div class="text-end">
          <div class="small opacity-75">TOTAL</div>
          <div class="fs-3 fw-bold">KES <?= money($inv['total']) ?></div>
        </div>
      </div>

      <div class="d-flex gap-2 mt-3">
        <button class="btn btn-primary w-100" onclick="window.print()">Print</button>
        <a class="btn btn-outline-light w-100" href="<?= base_url() ?>/public/pos/index.php">New sale</a>
      </div>

      <div class="text-center small opacity-75 mt-3">Served by: <?= h($_SESSION['user_name'] ?? 'User') ?></div>
    </div>
  </div>
</div>

<style>
@media print{ nav,.btn{display:none!important;} main{padding:0!important;} .card{box-shadow:none!important;border:0!important;} }
</style>

<?php include __DIR__ . '/../../includes/footer.php'; ?>
