<?php
require_once __DIR__ . '/../../includes/helpers.php';

$db = db();
$raw = file_get_contents('php://input');
$payload = json_decode($raw, true);
if (!is_array($payload)) { http_response_code(400); echo "Invalid"; exit; }

$stk = $payload['Body']['stkCallback'] ?? null;
if (!$stk){ http_response_code(200); echo "OK"; exit; }

$checkout = (string)($stk['CheckoutRequestID'] ?? '');
$resultCode = (string)($stk['ResultCode'] ?? '');
$resultDesc = (string)($stk['ResultDesc'] ?? '');

$receipt = null; $amount = null;
$items = $stk['CallbackMetadata']['Item'] ?? [];
if (is_array($items)){
  foreach($items as $it){
    if (($it['Name'] ?? '') === 'MpesaReceiptNumber') $receipt = (string)($it['Value'] ?? '');
    if (($it['Name'] ?? '') === 'Amount') $amount = (float)($it['Value'] ?? 0);
  }
}

$row = one($db, "SELECT * FROM mpesa_stk_requests WHERE checkout_request_id=? ORDER BY id DESC LIMIT 1", "s", [$checkout]);
if(!$row){ http_response_code(200); echo "OK"; exit; }

$status = ($resultCode === '0') ? 'SUCCESS' : 'FAILED';
$id = (int)$row['id'];

$st = $db->prepare("UPDATE mpesa_stk_requests SET result_code=?, result_desc=?, mpesa_receipt=?, callback_raw=?, status=? WHERE id=?");
$rawJson = json_encode($payload);
$st->bind_param("sssssi", $resultCode, $resultDesc, $receipt, $rawJson, $status, $id);
$st->execute(); $st->close();

if ($status === 'SUCCESS'){
  $invoice_id = (int)$row['invoice_id'];
  $customer_id = (int)$row['customer_id'];
  $amt = (float)($row['amount'] ?? $amount ?? 0);

  $pay_date = date('Y-m-d');
  $method = 'MPESA';
  $reference = $receipt ?: 'MPESA-STK';

  $stp = $db->prepare("INSERT INTO payments(customer_id,amount,payment_date,method,reference) VALUES(?,?,?,?,?)");
  $stp->bind_param("idsss", $customer_id, $amt, $pay_date, $method, $reference);
  $stp->execute(); $payment_id = $stp->insert_id; $stp->close();

  $stA = $db->prepare("INSERT INTO payment_allocations(payment_id,invoice_id,amount) VALUES(?,?,?)");
  $stA->bind_param("iid", $payment_id, $invoice_id, $amt);
  $stA->execute(); $stA->close();

  $db->query("UPDATE invoices SET balance = GREATEST(total - ".((float)$amt).",0) WHERE id=$invoice_id");
  $db->query("UPDATE invoices SET status = CASE WHEN balance<=0.0001 THEN 'Paid' WHEN balance<total THEN 'Partial' ELSE 'Unpaid' END WHERE id=$invoice_id");
}

http_response_code(200); echo "OK";
