<?php
require_once __DIR__ . '/_pos_boot.php';

$page_title = 'POS Terminal';
$items = all($db, "SELECT id,name FROM items ORDER BY name ASC");
$customers = all($db, "SELECT id,name FROM customers ORDER BY name ASC");

include __DIR__ . '/../../includes/header.php';
?>
<link rel="stylesheet" href="<?= base_url() ?>/assets/css/pos.css">

<div class="pos-shell">
  <div class="card p-3">
    <div class="d-flex justify-content-between align-items-center mb-2">
      <div>
        <div class="small opacity-75">Barcode-first POS</div>
        <div class="h5 mb-0">Scan / Add</div>
      </div>
      <a class="btn btn-outline-light btn-sm" href="<?= base_url() ?>/public/pos/receipt_last.php">Last Receipt</a>
    </div>

    <label class="form-label">Barcode</label>
    <input class="form-control form-control-lg mono mb-2" id="barcode" placeholder="Scan barcode then Enter" autocomplete="off">
    <div class="small opacity-75 mb-3">Cursor stays here for continuous scanning.</div>

    <div class="row g-2">
      <div class="col-8">
        <label class="form-label">Item (manual)</label>
        <select class="form-select" id="item_id">
          <option value="">Select item</option>
          <?php foreach($items as $it): ?>
            <option value="<?= (int)$it['id'] ?>"><?= h($it['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-4">
        <label class="form-label">Qty</label>
        <input class="form-control text-end" id="qty" type="number" step="0.001" value="1">
      </div>
      <div class="col-12">
        <label class="form-label">UOM</label>
        <select class="form-select" id="uom_id" disabled><option>Select item first</option></select>
      </div>
      <div class="col-12">
        <button class="btn btn-outline-info w-100" id="btnAddManual">Add to cart</button>
      </div>
    </div>

    <hr class="border-secondary my-3">

    <div class="d-flex gap-2">
      <button class="btn btn-outline-secondary w-100" id="btnClear">Clear cart</button>
      <a class="btn btn-outline-light w-100" href="<?= base_url() ?>/public/shifts.php">Shifts</a>
    </div>

    <div class="small opacity-75 mt-3">Shift: <?= isset($_SESSION['shift_id']) ? ('#'.(int)$_SESSION['shift_id'].' open') : 'none (optional)' ?></div>
  </div>

  <div class="card p-3">
    <div class="d-flex justify-content-between align-items-center mb-2">
      <div>
        <div class="small opacity-75">Cart</div>
        <div class="h5 mb-0">Checkout</div>
      </div>
      <div class="small opacity-75">User: <span class="text-light fw-semibold"><?= h($_SESSION['user_name'] ?? 'User') ?></span></div>
    </div>

    <div class="table-responsive">
      <table class="table table-sm align-middle">
        <thead>
          <tr>
            <th>Item</th>
            <th class="text-end" style="width:110px;">Qty</th>
            <th class="text-end" style="width:120px;">Price</th>
            <th class="text-end" style="width:140px;">Total</th>
            <th style="width:60px;"></th>
          </tr>
        </thead>
        <tbody id="cartBody">
          <tr><td colspan="5" class="opacity-75">Scan items to begin…</td></tr>
        </tbody>
      </table>
    </div>

    <div class="d-flex justify-content-end align-items-end gap-3 mt-2">
      <div class="text-end">
        <div class="small opacity-75">TOTAL</div>
        <div class="pos-total" id="totalText">KES 0.00</div>
      </div>
    </div>

    <hr class="border-secondary my-3">

    <div class="row g-2">
      <div class="col-12 col-lg-6">
        <label class="form-label">Customer</label>
        <select class="form-select" id="customer_id">
          <option value="0">Walk-in</option>
          <?php foreach($customers as $c): ?>
            <option value="<?= (int)$c['id'] ?>"><?= h($c['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-12 col-lg-6">
        <label class="form-label">M-Pesa phone (for STK)</label>
        <input class="form-control mono" id="mpesa_phone" placeholder="07XXXXXXXX or 2547XXXXXXXX">
      </div>
    </div>

    <div class="d-flex gap-2 mt-3">
      <button class="btn btn-success w-100 touch-highlight" onclick="doCheckout('cash')">CASH</button>
      <button class="btn btn-primary w-100 touch-highlight" onclick="doCheckout('mpesa')">MPESA STK</button>
      <button class="btn btn-warning w-100 touch-highlight" onclick="doCheckout('credit')">CREDIT</button>
    </div>

    <div class="small opacity-75 mt-2" id="statusLine"></div>
  </div>
</div>

<script>
const csrf = <?= json_encode(csrf_token()) ?>;

function money(n){ return (Number(n)||0).toLocaleString(undefined,{minimumFractionDigits:2,maximumFractionDigits:2}); }

async function post(url, data){
  const fd = new FormData();
  fd.append('csrf_token', csrf);
  for(const k in data) fd.append(k, data[k]);
  const res = await fetch(url, {method:'POST', body: fd});
  return await res.json();
}
function escapeHtml(s){ return String(s).replace(/[&<>"']/g, m => ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;'}[m])); }

function renderCart(cart, totals){
  const tbody = document.getElementById('cartBody');
  if(!cart || cart.length===0){
    tbody.innerHTML = `<tr><td colspan="5" class="opacity-75">Scan items to begin…</td></tr>`;
    document.getElementById('totalText').textContent = 'KES 0.00';
    return;
  }
  tbody.innerHTML = cart.map((l, idx)=>`
    <tr>
      <td><div class="fw-semibold">${escapeHtml(l.name)}</div><div class="small opacity-75">${escapeHtml(l.uom_name||'')}</div></td>
      <td class="text-end"><input class="form-control form-control-sm text-end" value="${l.qty}" type="number" step="0.001" onchange="changeQty(${idx}, this.value)"></td>
      <td class="text-end"><input class="form-control form-control-sm text-end" value="${l.price}" type="number" step="0.01" onchange="changePrice(${idx}, this.value)"></td>
      <td class="text-end fw-bold">KES ${money(l.line_total)}</td>
      <td class="text-end"><button class="btn btn-sm btn-outline-danger" onclick="removeLine(${idx})">×</button></td>
    </tr>
  `).join('');
  document.getElementById('totalText').textContent = 'KES ' + money((totals && totals.total) ? totals.total : 0);
}

function setStatus(msg, bad){
  const el = document.getElementById('statusLine');
  el.textContent = msg;
  el.style.color = bad ? '#fca5a5' : '#a7f3d0';
}

async function addByBarcode(code){
  const data = await post('<?= base_url() ?>/public/pos/api_add_barcode.php', {barcode: code});
  if(!data.ok){ setStatus('⚠️ ' + (data.msg || 'Failed'), true); }
  else{ setStatus('Added: ' + code, false); renderCart(data.cart, data.totals); }
}

async function addManual(){
  const itemId = document.getElementById('item_id').value;
  const uomId  = document.getElementById('uom_id').value;
  const qty    = document.getElementById('qty').value || 1;
  if(!itemId || !uomId){ setStatus('⚠️ Select item and UOM.', true); return; }
  const data = await post('<?= base_url() ?>/public/pos/api_add_line.php', {item_id:itemId, uom_id:uomId, qty:qty});
  if(data.ok){ setStatus('Added item', false); renderCart(data.cart, data.totals); }
  else setStatus('⚠️ ' + (data.msg||'Failed'), true);
}

async function changeQty(idx, v){
  const data = await post('<?= base_url() ?>/public/pos/api_update_line.php', {idx: idx, field:'qty', value:v});
  if(data.ok) renderCart(data.cart, data.totals);
}
async function changePrice(idx, v){
  const data = await post('<?= base_url() ?>/public/pos/api_update_line.php', {idx: idx, field:'price', value:v});
  if(data.ok) renderCart(data.cart, data.totals);
}
async function removeLine(idx){
  const data = await post('<?= base_url() ?>/public/pos/api_remove_line.php', {idx: idx});
  if(data.ok) renderCart(data.cart, data.totals);
}
async function clearCart(){
  const data = await post('<?= base_url() ?>/public/pos/api_clear.php', {});
  renderCart(data.cart, data.totals);
  setStatus('Cart cleared', false);
}

async function doCheckout(mode){
  const customer_id = document.getElementById('customer_id').value || 0;
  const phone = document.getElementById('mpesa_phone').value.trim();
  setStatus('Processing...', false);

  const data = await post('<?= base_url() ?>/public/pos/checkout.php', {mode: mode, customer_id: customer_id, mpesa_phone: phone});
  if(!data.ok){ setStatus('⛔ ' + (data.msg || (data.error || 'Checkout failed')), true); return; }

  if(mode==='mpesa'){
    setStatus('MPESA STK sent. Invoice ' + data.invoice_no, false);
    window.location.href = '<?= base_url() ?>/public/pos/receipt.php?invoice_id=' + encodeURIComponent(data.invoice_id);
    return;
  }

  setStatus('✅ Sale saved: ' + data.invoice_no, false);
  window.location.href = '<?= base_url() ?>/public/pos/receipt.php?invoice_id=' + encodeURIComponent(data.invoice_id);
}

document.getElementById('btnClear').addEventListener('click', clearCart);
document.getElementById('btnAddManual').addEventListener('click', addManual);

document.getElementById('item_id').addEventListener('change', async ()=>{
  const itemId = document.getElementById('item_id').value;
  const uomSel = document.getElementById('uom_id');
  uomSel.disabled = true;
  uomSel.innerHTML = '<option>Loading…</option>';
  if(!itemId){ uomSel.innerHTML = '<option>Select item first</option>'; return; }
  const res = await fetch('<?= base_url() ?>/public/api/uoms.php?item_id=' + encodeURIComponent(itemId));
  const data = await res.json();
  const uoms = (data && data.uoms) ? data.uoms : [];
  uomSel.innerHTML = '<option value="">Select UOM</option>' + uoms.map(u=>`<option value="${u.id}">${escapeHtml(u.uom_name)} (KES ${money(u.price)})</option>`).join('');
  uomSel.disabled = false;
});

const barcode = document.getElementById('barcode');
barcode.focus();
barcode.addEventListener('keydown', async (e)=>{
  if(e.key==='Enter'){
    e.preventDefault();
    const code = barcode.value.trim();
    if(!code) return;
    barcode.value = '';
    await addByBarcode(code);
    barcode.focus();
  }
});
</script>

<?php include __DIR__ . '/../../includes/footer.php'; ?>
