<?php
require_once __DIR__ . '/_pos_boot.php';
csrf_check();

$cart = pos_cart();
if(!$cart) json_out(['ok'=>false,'msg'=>'Cart is empty']);

$mode = $_POST['mode'] ?? 'walkin'; // cash|mpesa|credit|walkin
$customer_id = (int)($_POST['customer_id'] ?? 0);
$phone = trim($_POST['mpesa_phone'] ?? '');

if ($mode === 'walkin') { $mode = 'cash'; $customer_id = 0; }
if ($mode === 'credit' && $customer_id<=0) json_out(['ok'=>false,'msg'=>'Select customer for CREDIT']);

$pay_method = ($mode==='mpesa') ? 'MPESA' : (($mode==='credit') ? 'Credit' : 'Cash');

if($customer_id<=0) $customer_id = pos_walkin_customer_id($db);

$tot = pos_cart_totals($cart);
$total = (float)$tot['total'];

$db->begin_transaction();
try {
  $row = one($db, "SELECT COALESCE(MAX(id),0)+1 AS n FROM invoices");
  $n = (int)($row['n'] ?? 1);
  $invoice_no = 'INV' . date('Ymd') . '-' . str_pad((string)$n, 4, '0', STR_PAD_LEFT);

  $invoice_date = date('Y-m-d');
  $balance = $total;
  $status = 'Unpaid';

  $shift_id = (int)($_SESSION['shift_id'] ?? 0);
  if($shift_id<=0) $shift_id = null;

  $st = $db->prepare("INSERT INTO invoices(customer_id,shift_id,invoice_no,invoice_date,total,balance,status) VALUES(?,?,?,?,?,?,?)");
  $st->bind_param("iissdds", $customer_id, $shift_id, $invoice_no, $invoice_date, $total, $balance, $status);
  $st->execute();
  $invoice_id = $st->insert_id;
  $st->close();

  $ins = $db->prepare("INSERT INTO invoice_items(invoice_id,item_id,uom_id,qty,price,line_total,cost_total,profit) VALUES(?,?,?,?,?,?,?,?)");

  foreach($cart as $l){
    $item_id = (int)$l['item_id'];
    $uom_id  = (int)$l['uom_id'];
    $qty     = (float)$l['qty'];
    $price   = (float)$l['price'];
    $lt      = (float)$l['line_total'];

    $u2 = one($db, "SELECT conversion_qty, cost FROM item_uoms WHERE id=? AND item_id=?","ii",[$uom_id,$item_id]);
    $conv_qty = (float)($u2['conversion_qty'] ?? 1); if($conv_qty<=0) $conv_qty=1;
    $qty_base = $qty * $conv_qty;

    $on = one($db, "SELECT avg_cost_base FROM stock_onhand WHERE item_id=?","i",[$item_id]);
    $avg_cost_base = (float)($on['avg_cost_base'] ?? 0);
    if ($avg_cost_base <= 0.0000001) {
      $fallback_cost_uom = (float)($u2['cost'] ?? 0);
      $avg_cost_base = $fallback_cost_uom / $conv_qty;
    }
    $cost_total = $qty_base * $avg_cost_base;
    $profit = $lt - $cost_total;

    $ins->bind_param("iiiddddd", $invoice_id, $item_id, $uom_id, $qty, $price, $lt, $cost_total, $profit);
    $ins->execute();

    $db->query("INSERT INTO stock_onhand(item_id, qty_base, avg_cost_base) VALUES ($item_id, 0, 0)
                ON DUPLICATE KEY UPDATE item_id=item_id");
    $db->query("UPDATE stock_onhand SET qty_base = qty_base - ".((float)$qty_base)." WHERE item_id = $item_id");
    $db->query("INSERT INTO stock_moves(move_date,move_type,ref_type,ref_id,item_id,qty_base,cost_base,note)
                VALUES (NOW(),'SALE','invoice',$invoice_id,$item_id,".((float)(-$qty_base)).",".((float)$avg_cost_base).",'POS Sale')");
  }
  $ins->close();

  if ($pay_method === 'Cash') {
    $amount_paid = $total;
    $pay_date = date('Y-m-d');
    $method = 'Cash';
    $ref = 'POS-CASH';
    $stp = $db->prepare("INSERT INTO payments(customer_id,amount,payment_date,method,reference) VALUES(?,?,?,?,?)");
    $stp->bind_param("idsss", $customer_id, $amount_paid, $pay_date, $method, $ref);
    $stp->execute(); $payment_id = $stp->insert_id; $stp->close();

    $stA = $db->prepare("INSERT INTO payment_allocations(payment_id,invoice_id,amount) VALUES(?,?,?)");
    $stA->bind_param("iid", $payment_id, $invoice_id, $amount_paid);
    $stA->execute(); $stA->close();

    $db->query("UPDATE invoices SET balance = 0 WHERE id=$invoice_id");
  }

  $db->query("
    UPDATE invoices
    SET status = CASE
      WHEN balance <= 0.0001 THEN 'Paid'
      WHEN balance < total THEN 'Partial'
      ELSE 'Unpaid'
    END
    WHERE id = $invoice_id
  ");

  $db->commit();
  pos_cart_clear();

  if ($pay_method === 'MPESA') {
    $stk = mpesa_stk_push([
      'phone' => $phone,
      'amount' => $total,
      'account_reference' => $invoice_no,
      'transaction_desc' => 'POS Payment ' . $invoice_no
    ]);

    // store request
    $db = db();
    $status2 = $stk['ok'] ? 'PENDING' : 'FAILED';
    $resp = $stk['ok'] ? ($stk['response'] ?? []) : [];
    $mrid = $resp['MerchantRequestID'] ?? null;
    $crid = $resp['CheckoutRequestID'] ?? null;
    $rcode = $resp['ResponseCode'] ?? null;
    $rdesc = $resp['ResponseDescription'] ?? null;
    $cmsg  = $resp['CustomerMessage'] ?? null;

    $st = $db->prepare("INSERT INTO mpesa_stk_requests(invoice_id,customer_id,phone,amount,merchant_request_id,checkout_request_id,response_code,response_desc,customer_message,status)
                        VALUES(?,?,?,?,?,?,?,?,?,?)");
    $st->bind_param("iisdssssss", $invoice_id, $customer_id, $phone, $total, $mrid, $crid, $rcode, $rdesc, $cmsg, $status2);
    $st->execute(); $stk_id = $st->insert_id; $st->close();

    json_out(['ok'=>$stk['ok'], 'invoice_id'=>$invoice_id, 'invoice_no'=>$invoice_no, 'stk_id'=>$stk_id, 'stk'=>$stk]);
  }

  json_out(['ok'=>true,'invoice_id'=>$invoice_id,'invoice_no'=>$invoice_no,'total'=>$total,'pay_method'=>$pay_method]);

} catch (Throwable $e) {
  $db->rollback();
  json_out(['ok'=>false,'msg'=>$e->getMessage()]);
}
