<?php
require_once __DIR__ . '/_pos_boot.php';
csrf_check();

$barcode = trim($_POST['barcode'] ?? '');
if ($barcode==='') json_out(['ok'=>false,'msg'=>'No barcode']);

$item = one($db, "SELECT id,name FROM items WHERE barcode=? LIMIT 1", "s", [$barcode]);
if(!$item) json_out(['ok'=>false,'msg'=>'Barcode not found']);

$uoms = all($db, "SELECT id,uom_name,price FROM item_uoms WHERE item_id=? ORDER BY id ASC","i",[(int)$item['id']]);
if(!$uoms) json_out(['ok'=>false,'msg'=>'No UOMs for item']);

$u = $uoms[0];
$qty = 1.0;
$price = (float)$u['price'];
$cart = pos_cart();
$cart[] = [
  'item_id'=>(int)$item['id'],
  'uom_id'=>(int)$u['id'],
  'name'=>$item['name'],
  'uom_name'=>$u['uom_name'],
  'qty'=>$qty,
  'price'=>$price,
  'line_total'=>$qty*$price,
];
pos_cart_set($cart);
json_out(['ok'=>true,'cart'=>$cart,'totals'=>pos_cart_totals($cart)]);
