<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';
$page_title = 'Payments';
$db = db();

$pref_customer = (int)($_GET['customer_id'] ?? 0);

$customers = all($db, "SELECT id,name FROM customers ORDER BY name ASC");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  $customer_id = (int)($_POST['customer_id'] ?? 0);
  $amount = (float)($_POST['amount'] ?? 0);
  $date = $_POST['payment_date'] ?? date('Y-m-d');
  $method = trim($_POST['method'] ?? 'Cash');
  $ref = trim($_POST['reference'] ?? '');

  $alloc_invoice_id = $_POST['alloc_invoice_id'] ?? [];
  $alloc_amount     = $_POST['alloc_amount'] ?? [];

  if ($customer_id<=0 || $amount<=0) {
    flash_set('danger','Select customer and enter amount.');
    header('Location: ' . base_url() . '/public/payments.php');
    exit;
  }

  $db->begin_transaction();
  try {
    $st = $db->prepare("INSERT INTO payments(customer_id,amount,payment_date,method,reference) VALUES(?,?,?,?,?)");
    $st->bind_param("idsss", $customer_id, $amount, $date, $method, $ref);
    $st->execute();
    $payment_id = $st->insert_id;
    $st->close();

    $sumAlloc = 0.0;
    $ins = $db->prepare("INSERT INTO payment_allocations(payment_id, invoice_id, amount) VALUES(?,?,?)");

    for($i=0;$i<count($alloc_invoice_id);$i++){
      $inv_id = (int)$alloc_invoice_id[$i];
      $a = (float)($alloc_amount[$i] ?? 0);
      if($inv_id<=0 || $a<=0) continue;
      $sumAlloc += $a;
      $ins->bind_param("iid", $payment_id, $inv_id, $a);
      $ins->execute();

      // reduce invoice balance
      $db->query("UPDATE invoices SET balance = GREATEST(balance - ".((float)$a).", 0) WHERE id = ".((int)$inv_id)." AND customer_id = ".((int)$customer_id));
    }
    $ins->close();

    if ($sumAlloc - $amount > 0.0001) {
      throw new Exception("Allocated amount cannot exceed payment amount.");
    }

    // Update invoice statuses for this customer
    $db->query("
      UPDATE invoices
      SET status = CASE
        WHEN balance <= 0.0001 THEN 'Paid'
        WHEN balance < total THEN 'Partial'
        ELSE 'Unpaid'
      END
      WHERE customer_id = ".((int)$customer_id)."
    ");

    $db->commit();
    flash_set('success', 'Payment recorded and allocated.');
    header('Location: ' . base_url() . '/public/payments.php?customer_id=' . $customer_id);
    exit;
  } catch (Throwable $e) {
    $db->rollback();
    flash_set('danger', 'Failed: ' . $e->getMessage());
    header('Location: ' . base_url() . '/public/payments.php');
    exit;
  }
}

$selected_customer = $pref_customer>0 ? one($db, "SELECT id,name FROM customers WHERE id=?","i",[$pref_customer]) : null;
$open_invoices = $pref_customer>0 ? all($db, "SELECT id, invoice_no, invoice_date, total, balance FROM invoices WHERE customer_id=? AND balance>0.0001 ORDER BY id ASC","i",[$pref_customer]) : [];
$recent = all($db, "
  SELECT p.*, c.name AS customer_name
  FROM payments p
  JOIN customers c ON c.id=p.customer_id
  ORDER BY p.id DESC
  LIMIT 50
");

include __DIR__ . '/../includes/header.php';
?>
<div class="row g-3">
  <div class="col-12 col-lg-5">
    <div class="card p-3">
      <h5>Record payment</h5>
      <form method="post" class="mt-2">
        <?= csrf_field() ?>
        <div class="mb-2">
          <label class="form-label">Customer</label>
          <select class="form-select" name="customer_id" onchange="location='<?= base_url() ?>/public/payments.php?customer_id='+this.value" required>
            <option value="">Select customer</option>
            <?php foreach($customers as $c): ?>
              <option value="<?= (int)$c['id'] ?>" <?= ($pref_customer==(int)$c['id'])?'selected':'' ?>><?= h($c['name']) ?></option>
            <?php endforeach; ?>
          </select>
          <div class="small opacity-75 mt-1">Select a customer first to see open invoices for allocation.</div>
        </div>

        <div class="row g-2">
          <div class="col-6">
            <label class="form-label">Amount (KES)</label>
            <input class="form-control" name="amount" type="number" step="0.01" min="0" required>
          </div>
          <div class="col-6">
            <label class="form-label">Date</label>
            <input class="form-control" name="payment_date" type="date" value="<?= h(date('Y-m-d')) ?>" required>
          </div>
        </div>

        <div class="row g-2 mt-1">
          <div class="col-6">
            <label class="form-label">Method</label>
            <select class="form-select" name="method">
              <option>Cash</option>
              <option>MPESA</option>
              <option>Bank</option>
              <option>Cheque</option>
            </select>
          </div>
          <div class="col-6">
            <label class="form-label">Reference</label>
            <input class="form-control" name="reference" placeholder="e.g. MPESA Ref / Slip No">
          </div>
        </div>

        <hr class="border-secondary my-3">

        <h6 class="mb-2">Allocate to invoices (optional)</h6>
        <?php if(!$pref_customer): ?>
          <div class="opacity-75">Select a customer to allocate.</div>
        <?php elseif(!$open_invoices): ?>
          <div class="opacity-75">No open invoices for this customer.</div>
        <?php else: ?>
          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead><tr><th>Invoice</th><th>Date</th><th class="text-end">Balance</th><th class="text-end">Allocate</th></tr></thead>
              <tbody>
                <?php foreach($open_invoices as $inv): ?>
                  <tr>
                    <td class="fw-semibold"><?= h($inv['invoice_no']) ?></td>
                    <td><?= h($inv['invoice_date']) ?></td>
                    <td class="text-end">KES <?= money($inv['balance']) ?></td>
                    <td class="text-end">
                      <input type="hidden" name="alloc_invoice_id[]" value="<?= (int)$inv['id'] ?>">
                      <input class="form-control form-control-sm text-end" name="alloc_amount[]" type="number" step="0.01" min="0" max="<?= h($inv['balance']) ?>" value="0">
                    </td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
          <div class="small opacity-75">Tip: enter amounts per invoice. Total allocation must be ≤ payment amount.</div>
        <?php endif; ?>

        <button class="btn btn-primary mt-2 w-100">Save payment</button>
      </form>
    </div>
  </div>

  <div class="col-12 col-lg-7">
    <div class="card p-3">
      <h5 class="mb-2">Recent payments</h5>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>#</th><th>Date</th><th>Customer</th><th>Method</th><th class="text-end">Amount</th></tr></thead>
          <tbody>
            <?php foreach($recent as $p): ?>
              <tr>
                <td><?= (int)$p['id'] ?></td>
                <td><?= h($p['payment_date']) ?></td>
                <td><?= h($p['customer_name']) ?></td>
                <td><?= h($p['method']) ?></td>
                <td class="text-end">KES <?= money($p['amount']) ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <div class="small opacity-75">Shows last 50 payments.</div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
