<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/helpers.php';
$db = db();

$item_id = (int)($_GET['item_id'] ?? 0);
$item = $item_id ? one($db, "SELECT * FROM items WHERE id=?", "i", [$item_id]) : null;
if (!$item) { http_response_code(404); die('Item not found'); }

$page_title = 'UOMs & Prices — ' . $item['name'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_check();
  if (isset($_POST['add_uom'])) {
    $uom = trim($_POST['uom_name'] ?? '');
    $conv = (float)($_POST['conversion_qty'] ?? 1);
    $price = (float)($_POST['price'] ?? 0);
    $cost = (float)($_POST['cost'] ?? 0);
    if ($uom !== '' && $conv > 0) {
      $st = $db->prepare("INSERT INTO item_uoms(item_id,uom_name,conversion_qty,price,cost) VALUES(?,?,?,?,?)");
      $st->bind_param("isddd", $item_id, $uom, $conv, $price, $cost);
      $st->execute(); $st->close();
      flash_set('success', 'UOM added.');
    }
  } elseif (isset($_POST['delete_id'])) {
    $del = (int)$_POST['delete_id'];
    $st = $db->prepare("DELETE FROM item_uoms WHERE id=? AND item_id=?");
    $st->bind_param("ii", $del, $item_id);
    $st->execute(); $st->close();
    flash_set('success', 'UOM removed.');
  }
  header('Location: ' . base_url() . '/public/item_uoms.php?item_id=' . $item_id);
  exit;
}

$uoms = all($db, "SELECT * FROM item_uoms WHERE item_id=? ORDER BY id ASC", "i", [$item_id]);

include __DIR__ . '/../includes/header.php';
?>
<div class="row g-3">
  <div class="col-12 col-lg-4">
    <div class="card p-3">
      <div class="d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Add UOM</h5>
        <a class="btn btn-sm btn-outline-light" href="<?= base_url() ?>/public/items.php">Back</a>
      </div>
      <form method="post" class="mt-2">
        <?= csrf_field() ?>
        <input type="hidden" name="add_uom" value="1">
        <div class="mb-2">
          <label class="form-label">UOM name</label>
          <input class="form-control" name="uom_name" required placeholder="e.g. Carton / Outer / Pack / Pc">
        </div>
        <div class="mb-2">
          <label class="form-label">Conversion qty (base units)</label>
          <input class="form-control" name="conversion_qty" type="number" step="0.001" value="1" required>
          <div class="small opacity-75">Example: 1 carton = 1000 pcs → conversion_qty = 1000</div>
        </div>
        <div class="mb-2">
          <label class="form-label">Selling price (KES)</label>
          <input class="form-control" name="price" type="number" step="0.01" value="0" required>
        </div>
        <div class="mb-2">
          <label class="form-label">Default cost (KES) (optional)</label>
          <input class="form-control" name="cost" type="number" step="0.01" value="0">
          <div class="small opacity-75">Used as fallback if no GRN average cost yet.</div>
        </div>
        <button class="btn btn-primary">Save UOM</button>
      </form>
    </div>
  </div>

  <div class="col-12 col-lg-8">
    <div class="card p-3">
      <h5 class="mb-2"><?= h($item['name']) ?> — UOMs & prices</h5>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead><tr><th>UOM</th><th class="text-end">Conversion</th><th class="text-end">Price</th><th class="text-end">Cost</th><th></th></tr></thead>
          <tbody>
            <?php if(!$uoms): ?>
              <tr><td colspan="5" class="opacity-75">No UOMs yet. Add at least 1.</td></tr>
            <?php endif; ?>
            <?php foreach($uoms as $u): ?>
              <tr>
                <td><?= h($u['uom_name']) ?></td>
                <td class="text-end"><?= h($u['conversion_qty']) ?></td>
                <td class="text-end">KES <?= money($u['price']) ?></td>
                <td class="text-end">KES <?= money($u['cost']) ?></td>
                <td class="text-end">
                  <form method="post" class="d-inline" onsubmit="return confirm('Remove this UOM?');">
                    <?= csrf_field() ?>
                    <input type="hidden" name="delete_id" value="<?= (int)$u['id'] ?>">
                    <button class="btn btn-sm btn-outline-danger">Remove</button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../includes/footer.php'; ?>
