<?php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/helpers.php';
$cfg = app_cfg();
$flash = flash_get();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1,viewport-fit=cover">
  <meta name="theme-color" content="#0b1020">
  <title><?= isset($page_title) ? h($page_title).' • '.h($cfg['app_name']) : h($cfg['app_name']) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="<?= base_url() ?>/assets/css/app.css">
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark border-bottom border-secondary">
  <div class="container-fluid">
    <a class="navbar-brand fw-semibold" href="<?= base_url() ?>/public/dashboard.php"><?= h($cfg['app_name']) ?></a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="nav">
      <?php if(isset($_SESSION['user_id'])): ?>
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link" href="<?= base_url() ?>/public/dashboard.php">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= base_url() ?>/public/items.php">Items</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= base_url() ?>/public/customers.php">Customers</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= base_url() ?>/public/invoices.php">Invoices</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= base_url() ?>/public/payments.php">Payments</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= base_url() ?>/public/stock_onhand.php">Stock</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= base_url() ?>/public/grn_receive.php">GRN</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= base_url() ?>/public/returns.php">Returns</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= base_url() ?>/public/shifts.php">Shifts</a></li>
        <li class="nav-item"><a class="nav-link" href="<?= base_url() ?>/public/reports.php">Reports</a></li>
                <li class="nav-item"><a class="nav-link<?= nav_active('/public/pos/index.php') ?>" href="<?= base_url() ?>/public/pos/index.php">POS</a></li>
        </ul>
      <div class="d-flex gap-2 align-items-center">
        <span class="text-light small opacity-75">Hi, <?= h($_SESSION['user_name'] ?? 'User') ?></span>
        <a class="btn btn-outline-light btn-sm" href="<?= base_url() ?>/public/logout.php">Logout</a>
      </div>
      <?php endif; ?>
    </div>
  </div>
</nav>

<main class="container-fluid py-3">
  <?php if($flash): ?>
    <div class="alert alert-<?= h($flash['type']) ?>"><?= h($flash['msg']) ?></div>
  <?php endif; ?>
