<?php
// config/db.php
// Central DB bootstrap (mysqli) + helpers
if (session_status() === PHP_SESSION_NONE) session_start();

$app = require __DIR__ . '/app.php';
date_default_timezone_set($app['timezone'] ?? 'Africa/Nairobi');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

function db(): mysqli {
  static $conn = null;
  if ($conn) return $conn;

  $app = require __DIR__ . '/app.php';
  $cfg = $app['db'];
  $conn = new mysqli($cfg['host'], $cfg['user'], $cfg['pass'], $cfg['name']);
  $conn->set_charset($cfg['charset'] ?? 'utf8mb4');
  return $conn;
}
