# WholesaleOps MVP (Single Shop) — PHP + MySQL

A simple operations app for a wholesale shop:
- Items with multiple UOMs & different prices per UOM
- Customers (credit / walk-in)
- Sales invoices
- Payments & allocation (reconciliation)
- Customer statements + basic reports
- Mobile-friendly Bootstrap UI

## 1) Install (cPanel / XAMPP)
1. Create a MySQL database and user.
2. Import `database.sql`
3. Edit `config/app.php` and update DB credentials.
4. Upload the project to your hosting (e.g. `/public_html/wholesale_mvp_simple/`)
5. Open: `/public/`

## 2) Default login
- Email: `admin@local`
- Password: `admin123`

Change the password after first login by editing the user in DB (or extend a profile page).

## 3) Notes
- This MVP focuses on sales + credit + reconciliation.
- Stock control, GRN, LPO, transfers can be added as Phase 2.


## Phase 2 features added
- Stock on-hand (base units) + stock movements (GRN, Sale, Return)
- GRN receiving (updates weighted average cost)
- Barcode quick add on invoice screen
- Profit/margin reporting (estimated using avg cost)
- Shifts (open/close; optional)
- Returns (stock back-in; credit reduces invoice balance if linked)


## POS + M-Pesa STK
- POS: /public/pos/index.php
- MPESA callback: /public/pos/mpesa_callback.php (set as mpesa.callback_url in config/app.php)
